unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, GMP_Cutdown, GMP3DAPI;

type
  TForm1 = class(TForm)
    GMP1: TGMPCutdown;
    Timer1: TTimer;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CamPos, CamRot : TPoint3D;
    LightPos : Tpos4;
    Item : Integer;
    Rot : Single;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
     CamPos.X := 0;
     CamPos.Y := 0;
     CamPos.Z := -5;
     CamRot.X := 0;
     CamRot.Y := 0;
     CamRot.Z := 0;
     Rot := 0;
     LightPos.x := 0;
     LightPos.Y := 0;
     LightPos.Z := 10;
     LightPos.W := 1;

     GMP1.Start3D := True;
     GMP1.SetViewPort(0, 0, Form1.ClientWidth , Form1.ClientHeight );
     GMP1.SetCamera(CamPos, CamRot);
     GMP1.SetLight(True,LightPos, GMP1.Ambient_Default, GMP1.Diffuse_Default, GMP1.Specular_Default);
     GMP1.SetBuiltInMaterial('Gold');
     Timer1.Enabled := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
     GMP1.ClearBuffer;
     GMP1.ClearModelMatrix;
     GMP1.SetPosition(0,-0.5,3);
     GMP1.SetRotation(1,1,1,Rot);
     If rot > 360 then rot := 10;
     Rot := Rot + 10;
     GMP1.GMPCylinder(0.4,1);
     GMP1.SwapBackBuffer;

end;

end.
